# Supplemental Material for "DUMoE: Deep Unfolding Mixture-of-Experts for Compressive Imaging"

In this supplemental material, we provide the source code and pre-trained models for evaluating the performance of DUMoE on Compressive Imaging (CI) tasks, including natural image compressive sensing (ICS), CS magnetic resonance imaging (CS-MRI), and snapshot compressive imaging (SCI).

Please refer to the README.md file in each folder for more details.

## Structure of Supplemental Material
```
├── README.md
├── requirements.txt
└── 1.DUMoE_ICS/
    ├── README.md
    ├── main_test.py
    ├── moe_duns.py
    ├── register_models.py
    └── model/
        ├── checkpoint-dumoe-1-best.pth
        ├── checkpoint-dumoe-4-best.pth
        ├── checkpoint-dumoe-10-best.pth
        ├── checkpoint-dumoe-25-best.pth
    └── data/
        └── sampling_matrix/
            ├── 1_32.npy    
            ├── 4_32.npy    
            ├── 10_32.npy   
            ├── 25_32.npy   
        └── test/
            ├── README.md
└── 2.DUMoE_CSMRI/
    ├── README.md
    ├── main_test.py
    ├── moe_duns.py
    ├── register_models.py
    └── model/
        ├── checkpoint-dumoe-10-best.pth
    └── data/
        └── mask/
            └── 256/
                ├── README.md
        └── test/
            ├── README.md
└── 3.DUMoE_SCI/
    └── sim/
        └── test_code/
            ├── README.md
            ├── main_test.py
            ├── utils.py
            ├── option.py
            ├── template.py
            ├── ssim_torch.py
            └── architecture/
                ├── __init__.py
                ├── moe_duns.py
            └── model/
                ├── dumoe_sci_sim.pth
            └── data/
                └── SCI/
                    ├── README.md
    └── real/
        └── test_code/
            ├── README.md
            ├── main_test.py
            ├── option.py
            ├── template.py
            └── architecture/
                ├── __init__.py
                ├── moe_duns.py
            └── model/
            └── data/
                └── SCI/
                    ├── README.md
```